/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.urgentpath;

import com.google.common.collect.ImmutableList;
import cz.insophy.inplan.report.urgentpath.AbstractWaiting;
import cz.insophy.inplan.report.urgentpath.WaitingVisitor;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import java.util.Date;
import java.util.List;

public class MaterialWaiting
extends AbstractWaiting {
    private final ImmutableList<Material> materials;
    private final ImmutableList<Double> resourceRequirements;
    private final ImmutableList<Long> lengths;

    public MaterialWaiting(GeneralizedOrderRequest gor, GeneralizedActionRequest gar, List<Material> materials, List<Double> resourceRequirements, List<Long> lengths, long from, long length) {
        super(gor, gar, from, length);
        this.materials = ImmutableList.copyOf(materials);
        this.resourceRequirements = ImmutableList.copyOf(resourceRequirements);
        this.lengths = ImmutableList.copyOf(lengths);
    }

    public ImmutableList<Material> getMaterials() {
        return this.materials;
    }

    public ImmutableList<Double> getResourceRequirements() {
        return this.resourceRequirements;
    }

    public ImmutableList<Long> getLengths() {
        return this.lengths;
    }

    @Override
    public void accept(WaitingVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "MaterialWaiting{gor=" + this.gor.getId() + ", gar=" + this.gar.getAction() + ", materials=" + this.materials + ", resourceRequirements=" + this.resourceRequirements + ", lengths=" + this.lengths + ", from=" + new Date(this.from) + ", length=" + (double)this.length / 1000.0 / 3600.0 + " h}";
    }
}

